<?php
require_once '../config.php';
require_once '../classes/Questionnaire.php';
require_once '../classes/QuizAttempt.php';

if (!isStudent()) {
    redirect(BASE_URL . 'auth/login.php');
}

$questionnaire_id = intval($_GET['questionnaire_id'] ?? 0);
$questionnaire = new Questionnaire($conn);
$quiz_attempt = new QuizAttempt($conn);
$student_id = $_SESSION['user_id'];

$quiz = $questionnaire->getWithQuestions($questionnaire_id);

if (!$quiz || !$quiz['is_published']) {
    redirect(BASE_URL . 'student/dashboard.php');
}

// Start new attempt if not in progress
$current_attempt = $quiz_attempt->getCurrentAttempt($student_id, $questionnaire_id);

if (!$current_attempt) {
    $result = $quiz_attempt->startAttempt($student_id, $questionnaire_id);
    if ($result['success']) {
        $current_attempt = array('id' => $result['attempt_id']);
    } else {
        redirect(BASE_URL . 'student/dashboard.php');
    }
}

$attempt_id = $current_attempt['id'];

// Handle answer submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    if ($_POST['action'] === 'save_answer') {
        $question_id = intval($_POST['question_id'] ?? 0);
        $selected_option = isset($_POST['option_id']) ? intval($_POST['option_id']) : null;
        $answer_text = isset($_POST['answer_text']) ? sanitize($_POST['answer_text']) : null;
        
        $quiz_attempt->saveAnswer($attempt_id, $question_id, $selected_option, $answer_text);
    } elseif ($_POST['action'] === 'submit') {
        $result = $quiz_attempt->submitQuiz($attempt_id);
        if ($result['success']) {
            redirect(BASE_URL . 'student/quiz-result.php?attempt_id=' . $attempt_id);
        }
    }
}

$page_title = 'Take Quiz';
?>
<?php include '../includes/header.php'; ?>

<div class="container">
    <div class="quiz-container">
        <h1><?php echo htmlspecialchars($quiz['title']); ?></h1>
        
        <div class="quiz-timer">
            ⏱️ Time Remaining: <span id="timer"><?php echo $quiz['duration_minutes'] * 60; ?></span> seconds
        </div>
        
        <div class="question-progress">
            <?php foreach ($quiz['questions'] as $index => $q): ?>
                <div class="question-progress-item" onclick="scrollToQuestion(<?php echo $q['id']; ?>)">
                    <?php echo $index + 1; ?>
                </div>
            <?php endforeach; ?>
        </div>
        
        <form method="POST" action="" id="quizForm">
            <?php foreach ($quiz['questions'] as $index => $q): ?>
                <div class="question-card" id="question-<?php echo $q['id']; ?>">
                    <div class="question-number">Question <?php echo $index + 1; ?> of <?php echo count($quiz['questions']); ?> (<?php echo $q['marks']; ?> marks)</div>
                    <div class="question-text"><?php echo htmlspecialchars($q['question_text']); ?></div>
                    
                    <?php if ($q['question_type'] === 'multiple_choice'): ?>
                        <ul class="options-list">
                            <?php foreach ($q['options'] as $option): ?>
                                <li class="option">
                                    <input type="radio" name="question_<?php echo $q['id']; ?>" value="<?php echo $option['id']; ?>" onchange="autoSaveAnswer(<?php echo $q['id']; ?>)" id="option-<?php echo $option['id']; ?>">
                                    <label for="option-<?php echo $option['id']; ?>" style="margin: 0;"><?php echo htmlspecialchars($option['option_text']); ?></label>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    <?php elseif ($q['question_type'] === 'true_false'): ?>
                        <ul class="options-list">
                            <li class="option">
                                <input type="radio" name="question_<?php echo $q['id']; ?>" value="true" onchange="autoSaveAnswer(<?php echo $q['id']; ?>)" id="option-true-<?php echo $q['id']; ?>">
                                <label for="option-true-<?php echo $q['id']; ?>" style="margin: 0;">True</label>
                            </li>
                            <li class="option">
                                <input type="radio" name="question_<?php echo $q['id']; ?>" value="false" onchange="autoSaveAnswer(<?php echo $q['id']; ?>)" id="option-false-<?php echo $q['id']; ?>">
                                <label for="option-false-<?php echo $q['id']; ?>" style="margin: 0;">False</label>
                            </li>
                        </ul>
                    <?php else: ?>
                        <textarea name="question_<?php echo $q['id']; ?>" onchange="autoSaveAnswer(<?php echo $q['id']; ?>)" placeholder="Enter your answer here..."></textarea>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
            
            <div class="quiz-navigation">
                <button type="submit" name="action" value="submit" class="btn btn-success">Submit Quiz</button>
            </div>
        </form>
    </div>
</div>

<script>
    const totalSeconds = <?php echo $quiz['duration_minutes'] * 60; ?>;
    let remainingSeconds = totalSeconds;
    
    function updateTimer() {
        const minutes = Math.floor(remainingSeconds / 60);
        const seconds = remainingSeconds % 60;
        document.getElementById('timer').textContent = remainingSeconds;
        
        if (remainingSeconds <= 0) {
            document.getElementById('quizForm').submit();
        }
        
        remainingSeconds--;
        setTimeout(updateTimer, 1000);
    }
    
    function scrollToQuestion(questionId) {
        document.getElementById('question-' + questionId).scrollIntoView({ behavior: 'smooth' });
    }
    
    function autoSaveAnswer(questionId) {
        const form = new FormData(document.getElementById('quizForm'));
        const data = new FormData();
        data.append('action', 'save_answer');
        data.append('question_id', questionId);
        data.append('option_id', form.get('question_' + questionId));
        data.append('answer_text', form.get('question_' + questionId));
        
        fetch('<?php echo BASE_URL; ?>student/take-quiz.php?questionnaire_id=<?php echo $questionnaire_id; ?>', {
            method: 'POST',
            body: data
        });
    }
    
    updateTimer();
</script>

</body>
</html>
