<?php
require_once '../config.php';
require_once '../classes/QuizAttempt.php';

if (!isStudent()) {
    redirect(BASE_URL . 'auth/login.php');
}

$attempt_id = intval($_GET['attempt_id'] ?? 0);
$quiz_attempt = new QuizAttempt($conn);

$attempt = $quiz_attempt->getAttemptDetails($attempt_id);

if (!$attempt || $attempt['student_id'] !== $_SESSION['user_id']) {
    redirect(BASE_URL . 'student/dashboard.php');
}

// Get questionnaire info
$query = "SELECT * FROM questionnaires WHERE id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $attempt['questionnaire_id']);
$stmt->execute();
$questionnaire = $stmt->get_result()->fetch_assoc();

$passed = $attempt['percentage'] >= $questionnaire['passing_percentage'];

$page_title = 'Quiz Result';
?>
<?php include '../includes/header.php'; ?>

<div class="container">
    <div class="quiz-container">
        <div style="text-align: center; margin-bottom: 2rem;">
            <?php if ($passed): ?>
                <div style="font-size: 3rem;">🎉</div>
                <h1 style="color: var(--success-color);">Congratulations! You Passed!</h1>
            <?php else: ?>
                <div style="font-size: 3rem;">📚</div>
                <h1 style="color: var(--danger-color);">Quiz Completed</h1>
            <?php endif; ?>
        </div>
        
        <div class="stats-grid" style="margin-bottom: 2rem;">
            <div class="stat-card">
                <div class="stat-label">Your Score</div>
                <div class="stat-value" style="color: <?php echo $passed ? 'var(--success-color)' : 'var(--danger-color)'; ?>">
                    <?php echo number_format($attempt['percentage'], 2); ?>%
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-label">Marks Obtained</div>
                <div class="stat-value"><?php echo $attempt['obtained_marks']; ?>/<?php echo $attempt['total_marks']; ?></div>
            </div>
            
            <div class="stat-card">
                <div class="stat-label">Passing Percentage</div>
                <div class="stat-value"><?php echo $questionnaire['passing_percentage']; ?>%</div>
            </div>
            
            <div class="stat-card">
                <div class="stat-label">Status</div>
                <div style="margin-top: 0.5rem;">
                    <?php if ($passed): ?>
                        <span class="badge badge-success" style="font-size: 1.1rem;">PASS</span>
                    <?php else: ?>
                        <span class="badge badge-danger" style="font-size: 1.1rem;">FAIL</span>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <div class="card">
            <div class="card-header">
                <div class="card-title">Review Your Answers</div>
            </div>
            <div class="card-content">
                <?php if ($attempt['answers']): ?>
                    <?php foreach ($attempt['answers'] as $index => $answer): ?>
                        <div class="question-card" style="border-color: <?php echo $answer['is_correct'] ? 'var(--success-color)' : 'var(--danger-color)'; ?>">
                            <div style="display: flex; justify-content: space-between; align-items: flex-start;">
                                <div>
                                    <div class="question-number">Question <?php echo $index + 1; ?></div>
                                    <div class="question-text"><?php echo htmlspecialchars($answer['question_text']); ?></div>
                                    
                                    <?php if ($answer['is_correct']): ?>
                                        <div style="color: var(--success-color); font-weight: bold; margin-top: 0.5rem;">✓ Correct</div>
                                    <?php else: ?>
                                        <div style="color: var(--danger-color); font-weight: bold; margin-top: 0.5rem;">✗ Incorrect</div>
                                    <?php endif; ?>
                                    
                                    <div style="margin-top: 1rem;">
                                        <strong>Your Answer:</strong>
                                        <div class="text-muted"><?php echo htmlspecialchars($answer['option_text'] ?? $answer['answer_text'] ?? 'No answer'); ?></div>
                                    </div>
                                </div>
                                <div style="text-align: right;">
                                    <div style="font-size: 1.5rem; font-weight: bold; color: var(--primary-color);">
                                        <?php echo $answer['marks_obtained']; ?>/<?php echo $answer['marks']; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
        
        <div style="margin-top: 2rem; text-align: center;">
            <a href="<?php echo BASE_URL; ?>student/dashboard.php" class="btn btn-primary">Back to Dashboard</a>
        </div>
    </div>
</div>

</body>
</html>
