<?php
require_once '../config.php';
require_once '../classes/Questionnaire.php';

if (!isStudent()) {
    redirect(BASE_URL . 'auth/login.php');
}

$questionnaire = new Questionnaire($conn);
$student_id = $_SESSION['user_id'];

// Get assigned questionnaires
$query = "SELECT q.* FROM questionnaires q
          JOIN student_questionnaire sq ON q.id = sq.questionnaire_id
          WHERE sq.student_id = ? AND q.is_published = 1
          ORDER BY q.created_at DESC";

$stmt = $conn->prepare($query);
$stmt->bind_param("i", $student_id);
$stmt->execute();
$assigned_quizzes = $stmt->get_result();

$page_title = 'Student Dashboard';
?>
<?php include '../includes/header.php'; ?>

<div class="container">
    <h1>Welcome, <?php echo $_SESSION['full_name']; ?>!</h1>
    
    <div class="card">
        <div class="card-header">
            <div class="card-title">Available Quizzes</div>
        </div>
        <div class="card-content">
            <?php if ($assigned_quizzes->num_rows > 0): ?>
                <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(300px, 1fr)); gap: 1.5rem;">
                    <?php while ($quiz = $assigned_quizzes->fetch_assoc()): ?>
                        <div class="card" style="margin-bottom: 0;">
                            <h3><?php echo htmlspecialchars($quiz['title']); ?></h3>
                            <p class="text-muted"><?php echo htmlspecialchars($quiz['description']); ?></p>
                            
                            <div style="margin: 1rem 0;">
                                <small class="text-muted">
                                    ⏱️ Duration: <?php echo $quiz['duration_minutes']; ?> minutes<br>
                                    ✓ Passing: <?php echo $quiz['passing_percentage']; ?>%
                                </small>
                            </div>
                            
                            <div>
                                <?php
                                // Check if already attempted
                                $attempt_query = "SELECT * FROM student_attempts 
                                               WHERE student_id = ? AND questionnaire_id = ? AND status = 'graded'
                                               ORDER BY end_time DESC LIMIT 1";
                                $attempt_stmt = $conn->prepare($attempt_query);
                                $attempt_stmt->bind_param("ii", $student_id, $quiz['id']);
                                $attempt_stmt->execute();
                                $last_attempt = $attempt_stmt->get_result()->fetch_assoc();
                                ?>
                                
                                <?php if ($last_attempt): ?>
                                    <p><span class="badge badge-success">Completed</span></p>
                                    <small class="text-muted">
                                        Score: <?php echo number_format($last_attempt['percentage'], 2); ?>%
                                        (<?php echo $last_attempt['obtained_marks']; ?>/<?php echo $last_attempt['total_marks']; ?>)
                                    </small>
                                    <a href="<?php echo BASE_URL; ?>student/take-quiz.php?questionnaire_id=<?php echo $quiz['id']; ?>" class="btn btn-sm btn-primary">Retake Quiz</a>
                                <?php else: ?>
                                    <a href="<?php echo BASE_URL; ?>student/take-quiz.php?questionnaire_id=<?php echo $quiz['id']; ?>" class="btn btn-sm btn-primary">Start Quiz</a>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>
            <?php else: ?>
                <p class="text-muted">No quizzes assigned to you yet.</p>
            <?php endif; ?>
        </div>
    </div>
</div>

</body>
</html>
