<?php
// Check if user is logged in, if not redirect to login
if (!isset($_SESSION['user_id'])) {
    header("Location: " . BASE_URL . "auth/login.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($page_title) ? $page_title . ' - Quiz System' : 'Quiz System'; ?></title>
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>public/css/style.css">
</head>
<body>
    <header>
        <nav>
            <a href="<?php echo BASE_URL; ?>" class="logo">📚 Quiz System</a>
            <ul class="nav-links">
                <?php if (isAdmin()): ?>
                    <li><a href="<?php echo BASE_URL; ?>admin/dashboard.php">Dashboard</a></li>
                    <li><a href="<?php echo BASE_URL; ?>admin/questionnaires.php">Questionnaires</a></li>
                    <li><a href="<?php echo BASE_URL; ?>admin/reports.php">Reports</a></li>
                <?php elseif (isStudent()): ?>
                    <li><a href="<?php echo BASE_URL; ?>student/dashboard.php">Dashboard</a></li>
                    <li><a href="<?php echo BASE_URL; ?>student/quizzes.php">Available Quizzes</a></li>
                    <li><a href="<?php echo BASE_URL; ?>student/progress.php">My Progress</a></li>
                <?php endif; ?>
            </ul>
            <div class="user-menu">
                <span>Welcome, <strong><?php echo $_SESSION['full_name']; ?></strong></span>
                <a href="<?php echo BASE_URL; ?>auth/logout.php" class="btn-logout">Logout</a>
            </div>
        </nav>
    </header>
