<?php
require_once '../config.php';
require_once '../classes/Report.php';

if (!isAdmin()) {
    redirect(BASE_URL . 'auth/login.php');
}

$student_id = intval($_GET['student_id'] ?? 0);
$report = new Report($conn);

$student_report = $report->getStudentReport($student_id);
if (!$student_report) {
    redirect(BASE_URL . 'admin/reports.php');
}

$attempts_result = $report->getStudentQuizAttempts($student_id);

$page_title = 'Student Details';
?>
<?php include '../includes/header.php'; ?>

<div class="container">
    <div class="card">
        <div class="card-header">
            <div class="card-title">Student Information</div>
        </div>
        <div class="card-content">
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem;">
                <div>
                    <p><strong>Name:</strong> <?php echo htmlspecialchars($student_report['full_name']); ?></p>
                    <p><strong>Email:</strong> <?php echo htmlspecialchars($student_report['email']); ?></p>
                    <p><strong>Member Since:</strong> <?php echo date('F j, Y', strtotime($student_report['created_at'])); ?></p>
                </div>
            </div>
        </div>
    </div>
    
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-label">Quizzes Attempted</div>
            <div class="stat-value"><?php echo $student_report['quizzes_attempted']; ?></div>
        </div>
        
        <div class="stat-card">
            <div class="stat-label">Total Attempts</div>
            <div class="stat-value"><?php echo $student_report['total_attempts']; ?></div>
        </div>
        
        <div class="stat-card">
            <div class="stat-label">Average Score</div>
            <div class="stat-value"><?php echo number_format($student_report['average_percentage'] ?? 0, 2); ?>%</div>
        </div>
        
        <div class="stat-card">
            <div class="stat-label">Highest Score</div>
            <div class="stat-value"><?php echo number_format($student_report['highest_score'] ?? 0, 2); ?>%</div>
        </div>
    </div>
    
    <div class="card">
        <div class="card-header">
            <div class="card-title">Quiz Attempts</div>
        </div>
        <div class="card-content">
            <?php if ($attempts_result->num_rows > 0): ?>
                <table class="table">
                    <thead>
                        <tr>
                            <th>Quiz Title</th>
                            <th>Start Date</th>
                            <th>End Date</th>
                            <th>Score</th>
                            <th>Percentage</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($attempt = $attempts_result->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($attempt['questionnaire_title']); ?></td>
                                <td><?php echo date('M d, Y H:i', strtotime($attempt['start_time'])); ?></td>
                                <td><?php echo date('M d, Y H:i', strtotime($attempt['end_time'])); ?></td>
                                <td><?php echo $attempt['obtained_marks']; ?>/<?php echo $attempt['total_marks']; ?></td>
                                <td>
                                    <div class="progress" style="margin: 0;">
                                        <div class="progress-bar" style="width: <?php echo $attempt['percentage']; ?>%">
                                            <?php echo number_format($attempt['percentage'], 1); ?>%
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <?php if ($attempt['percentage'] >= 60): ?>
                                        <span class="badge badge-success">Pass</span>
                                    <?php else: ?>
                                        <span class="badge badge-danger">Fail</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p class="text-muted">No attempts found.</p>
            <?php endif; ?>
        </div>
    </div>
    
    <a href="<?php echo BASE_URL; ?>admin/reports.php" class="btn btn-outline">Back to Reports</a>
</div>

</body>
</html>
