<?php
require_once '../config.php';
require_once '../classes/Report.php';
require_once '../classes/Questionnaire.php';

if (!isAdmin()) {
    redirect(BASE_URL . 'auth/login.php');
}

$report = new Report($conn);
$questionnaire = new Questionnaire($conn);

$page_title = 'Reports';
?>
<?php include '../includes/header.php'; ?>

<div class="container">
    <div class="card">
        <div class="card-header">
            <div class="card-title">Overall Statistics</div>
        </div>
        <div class="card-content">
            <?php
            $stats = $report->getClassStatistics();
            ?>
            <div class="stats-grid">
                <div class="stat-card">
                    <div class="stat-label">Total Students</div>
                    <div class="stat-value"><?php echo $stats['total_students'] ?? 0; ?></div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-label">Total Quizzes</div>
                    <div class="stat-value"><?php echo $stats['total_questionnaires'] ?? 0; ?></div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-label">Total Attempts</div>
                    <div class="stat-value"><?php echo $stats['total_attempts'] ?? 0; ?></div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-label">Class Average</div>
                    <div class="stat-value"><?php echo number_format($stats['class_average'] ?? 0, 2); ?>%</div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="card">
        <div class="card-header">
            <div class="card-title">Student Performance</div>
        </div>
        <div class="card-content">
            <?php
            $students_result = $report->getAllStudentsReport();
            ?>
            <?php if ($students_result->num_rows > 0): ?>
                <table class="table">
                    <thead>
                        <tr>
                            <th>Student Name</th>
                            <th>Email</th>
                            <th>Quizzes Attempted</th>
                            <th>Total Attempts</th>
                            <th>Average Score</th>
                            <th>Highest Score</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($student = $students_result->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($student['full_name']); ?></td>
                                <td><?php echo htmlspecialchars($student['email']); ?></td>
                                <td><?php echo $student['quizzes_attempted']; ?></td>
                                <td><?php echo $student['total_attempts']; ?></td>
                                <td>
                                    <?php if ($student['average_percentage']): ?>
                                        <div class="progress" style="margin: 0;">
                                            <div class="progress-bar" style="width: <?php echo $student['average_percentage']; ?>%">
                                                <?php echo number_format($student['average_percentage'], 1); ?>%
                                            </div>
                                        </div>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php echo isset($student['highest_score']) ? number_format($student['highest_score'], 2) . '%' : '-'; ?>
                                </td>
                                <td>
                                    <a href="<?php echo BASE_URL; ?>admin/student-detail.php?student_id=<?php echo $student['id']; ?>" class="btn btn-sm btn-primary">View Details</a>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p class="text-muted">No students found.</p>
            <?php endif; ?>
        </div>
    </div>
    
    <div class="card">
        <div class="card-header">
            <div class="card-title">Quiz Performance</div>
        </div>
        <div class="card-content">
            <?php
            $questionnaires_result = $questionnaire->getAllQuestionnaires();
            ?>
            <?php if ($questionnaires_result->num_rows > 0): ?>
                <table class="table">
                    <thead>
                        <tr>
                            <th>Quiz Title</th>
                            <th>Students Attempted</th>
                            <th>Average Score</th>
                            <th>Highest Score</th>
                            <th>Lowest Score</th>
                            <th>Pass Rate</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($quiz = $questionnaires_result->fetch_assoc()): ?>
                            <?php
                            $quiz_report = $report->getQuestionnaireReport($quiz['id']);
                            $pass_rate = ($quiz_report['students_attempted'] > 0) ? 
                                        ($quiz_report['passed_count'] / $quiz_report['students_attempted']) * 100 : 0;
                            ?>
                            <tr>
                                <td><?php echo htmlspecialchars($quiz['title']); ?></td>
                                <td><?php echo $quiz_report['students_attempted']; ?></td>
                                <td><?php echo $quiz_report['average_percentage'] ? number_format($quiz_report['average_percentage'], 2) . '%' : '-'; ?></td>
                                <td><?php echo $quiz_report['highest_score'] ? number_format($quiz_report['highest_score'], 2) . '%' : '-'; ?></td>
                                <td><?php echo $quiz_report['lowest_score'] ? number_format($quiz_report['lowest_score'], 2) . '%' : '-'; ?></td>
                                <td>
                                    <div class="progress" style="margin: 0;">
                                        <div class="progress-bar" style="width: <?php echo $pass_rate; ?>%">
                                            <?php echo number_format($pass_rate, 1); ?>%
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <a href="<?php echo BASE_URL; ?>admin/quiz-detail.php?quiz_id=<?php echo $quiz['id']; ?>" class="btn btn-sm btn-primary">Details</a>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p class="text-muted">No quizzes found.</p>
            <?php endif; ?>
        </div>
    </div>
</div>

</body>
</html>
