<?php
require_once '../config.php';
require_once '../classes/Questionnaire.php';
require_once '../classes/Question.php';
require_once '../classes/Option.php';

if (!isAdmin()) {
    redirect(BASE_URL . 'auth/login.php');
}

$questionnaire_id = intval($_GET['questionnaire_id'] ?? 0);
$questionnaire = new Questionnaire($conn);
$question = new Question($conn);
$option = new Option($conn);

$quiz = $questionnaire->getWithQuestions($questionnaire_id);

if (!$quiz) {
    redirect(BASE_URL . 'admin/questionnaires.php');
}

$message = '';
$error = '';

// Add question
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    if ($_POST['action'] === 'add_question') {
        $question_text = sanitize($_POST['question_text'] ?? '');
        $question_type = sanitize($_POST['question_type'] ?? 'multiple_choice');
        $marks = intval($_POST['marks'] ?? 1);
        
        $result = $question->add($questionnaire_id, $question_text, $question_type, $marks);
        
        if ($result['success']) {
            header("Location: " . $_SERVER['REQUEST_URI']);
            exit();
        } else {
            $error = 'Failed to add question';
        }
    }
}

$page_title = 'Manage Questions';
?>
<?php include '../includes/header.php'; ?>

<div class="container">
    <div class="card">
        <div class="card-header">
            <div class="card-title">Questionnaire: <?php echo htmlspecialchars($quiz['title']); ?></div>
        </div>
    </div>
    
    <div class="card">
        <div class="card-header">
            <div class="card-title">Add Question</div>
        </div>
        <div class="card-content">
            <?php if ($error): ?>
                <div class="alert alert-danger"><?php echo $error; ?></div>
            <?php endif; ?>
            
            <form method="POST" action="">
                <input type="hidden" name="action" value="add_question">
                
                <div class="form-group">
                    <label for="question_text">Question Text</label>
                    <textarea id="question_text" name="question_text" required></textarea>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label for="question_type">Question Type</label>
                        <select id="question_type" name="question_type">
                            <option value="multiple_choice">Multiple Choice</option>
                            <option value="true_false">True/False</option>
                            <option value="short_answer">Short Answer</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="marks">Marks</label>
                        <input type="number" id="marks" name="marks" value="1" min="1">
                    </div>
                </div>
                
                <button type="submit" class="btn btn-primary">Add Question</button>
            </form>
        </div>
    </div>
    
    <div class="card">
        <div class="card-header">
            <div class="card-title">Questions (<?php echo count($quiz['questions']); ?>)</div>
        </div>
        <div class="card-content">
            <?php if (count($quiz['questions']) > 0): ?>
                <?php foreach ($quiz['questions'] as $q): ?>
                    <div class="question-card">
                        <div style="display: flex; justify-content: space-between;">
                            <div>
                                <div class="question-number">Question <?php echo $q['display_order']; ?> - <?php echo ucfirst(str_replace('_', ' ', $q['question_type'])); ?></div>
                                <div class="question-text"><?php echo htmlspecialchars($q['question_text']); ?></div>
                                <small class="text-muted">Marks: <?php echo $q['marks']; ?></small>
                            </div>
                            <div style="text-align: right;">
                                <a href="<?php echo BASE_URL; ?>admin/edit-question.php?id=<?php echo $q['id']; ?>&questionnaire_id=<?php echo $questionnaire_id; ?>" class="btn btn-sm btn-primary">Edit</a>
                                <a href="<?php echo BASE_URL; ?>admin/options.php?question_id=<?php echo $q['id']; ?>" class="btn btn-sm btn-secondary">Options</a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <p class="text-muted">No questions added yet.</p>
            <?php endif; ?>
        </div>
    </div>
    
    <div style="margin-top: 2rem;">
        <?php if (count($quiz['questions']) > 0 && !$quiz['is_published']): ?>
            <a href="<?php echo BASE_URL; ?>admin/publish-questionnaire.php?id=<?php echo $questionnaire_id; ?>" class="btn btn-success">Publish Questionnaire</a>
        <?php endif; ?>
        <a href="<?php echo BASE_URL; ?>admin/questionnaires.php" class="btn btn-outline">Back</a>
    </div>
</div>

</body>
</html>
