<?php
require_once '../config.php';
require_once '../classes/Questionnaire.php';

if (!isAdmin()) {
    redirect(BASE_URL . 'auth/login.php');
}

$questionnaire_id = intval($_GET['id'] ?? 0);
$questionnaire = new Questionnaire($conn);

$quiz = $questionnaire->getById($questionnaire_id);

if (!$quiz) {
    redirect(BASE_URL . 'admin/questionnaires.php');
}

// Check if there are questions
$query = "SELECT COUNT(*) as count FROM questions WHERE questionnaire_id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $questionnaire_id);
$stmt->execute();
$result = $stmt->get_result()->fetch_assoc();

if ($result['count'] === 0) {
    redirect(BASE_URL . 'admin/questions.php?questionnaire_id=' . $questionnaire_id);
}

$result = $questionnaire->publish($questionnaire_id);

if ($result['success']) {
    header("Location: " . BASE_URL . "admin/questionnaires.php?message=published");
} else {
    header("Location: " . BASE_URL . "admin/questions.php?questionnaire_id=" . $questionnaire_id . "&error=failed");
}
?>
