<?php
require_once '../config.php';
require_once '../classes/Questionnaire.php';

if (!isAdmin()) {
    redirect(BASE_URL . 'auth/login.php');
}

$questionnaire_id = intval($_GET['id'] ?? 0);
$questionnaire = new Questionnaire($conn);
$quiz = $questionnaire->getById($questionnaire_id);

if (!$quiz) {
    redirect(BASE_URL . 'admin/questionnaires.php');
}

$message = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = sanitize($_POST['title'] ?? '');
    $description = sanitize($_POST['description'] ?? '');
    $duration = intval($_POST['duration_minutes'] ?? 30);
    $passing = intval($_POST['passing_percentage'] ?? 60);
    
    $result = $questionnaire->update($questionnaire_id, $title, $description, $duration, $passing);
    
    if ($result['success']) {
        $message = 'Questionnaire updated successfully';
        $quiz = $questionnaire->getById($questionnaire_id);
    } else {
        $error = 'Failed to update questionnaire';
    }
}

$page_title = 'Edit Questionnaire';
?>
<?php include '../includes/header.php'; ?>

<div class="container">
    <div class="card">
        <div class="card-header">
            <div class="card-title">Edit Questionnaire</div>
        </div>
        <div class="card-content">
            <?php if ($message): ?>
                <div class="alert alert-success"><?php echo $message; ?></div>
            <?php endif; ?>
            
            <?php if ($error): ?>
                <div class="alert alert-danger"><?php echo $error; ?></div>
            <?php endif; ?>
            
            <form method="POST" action="">
                <div class="form-group">
                    <label for="title">Title</label>
                    <input type="text" id="title" name="title" value="<?php echo htmlspecialchars($quiz['title']); ?>" required>
                </div>
                
                <div class="form-group">
                    <label for="description">Description</label>
                    <textarea id="description" name="description"><?php echo htmlspecialchars($quiz['description']); ?></textarea>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label for="duration_minutes">Duration (minutes)</label>
                        <input type="number" id="duration_minutes" name="duration_minutes" value="<?php echo $quiz['duration_minutes']; ?>" min="1">
                    </div>
                    <div class="form-group">
                        <label for="passing_percentage">Passing Percentage</label>
                        <input type="number" id="passing_percentage" name="passing_percentage" value="<?php echo $quiz['passing_percentage']; ?>" min="0" max="100">
                    </div>
                </div>
                
                <button type="submit" class="btn btn-primary">Update Questionnaire</button>
                <a href="<?php echo BASE_URL; ?>admin/questionnaires.php" class="btn btn-outline">Cancel</a>
            </form>
        </div>
    </div>
</div>

</body>
</html>
