<?php
require_once '../config.php';
require_once '../classes/Question.php';
require_once '../classes/Questionnaire.php';

if (!isAdmin()) {
    redirect(BASE_URL . 'auth/login.php');
}

$question_id = intval($_GET['id'] ?? 0);
$questionnaire_id = intval($_GET['questionnaire_id'] ?? 0);

$question = new Question($conn);
$q = $question->getById($question_id);

if (!$q) {
    redirect(BASE_URL . 'admin/questionnaires.php');
}

$message = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $question_text = sanitize($_POST['question_text'] ?? '');
    $marks = intval($_POST['marks'] ?? 1);
    
    $result = $question->update($question_id, $question_text, $marks);
    
    if ($result['success']) {
        $message = 'Question updated successfully';
        $q = $question->getById($question_id);
    } else {
        $error = 'Failed to update question';
    }
}

$page_title = 'Edit Question';
?>
<?php include '../includes/header.php'; ?>

<div class="container">
    <div class="card">
        <div class="card-header">
            <div class="card-title">Edit Question</div>
        </div>
        <div class="card-content">
            <?php if ($message): ?>
                <div class="alert alert-success"><?php echo $message; ?></div>
            <?php endif; ?>
            
            <?php if ($error): ?>
                <div class="alert alert-danger"><?php echo $error; ?></div>
            <?php endif; ?>
            
            <form method="POST" action="">
                <div class="form-group">
                    <label for="question_text">Question Text</label>
                    <textarea id="question_text" name="question_text" required><?php echo htmlspecialchars($q['question_text']); ?></textarea>
                </div>
                
                <div class="form-group">
                    <label for="marks">Marks</label>
                    <input type="number" id="marks" name="marks" value="<?php echo $q['marks']; ?>" min="1">
                </div>
                
                <p class="text-muted"><strong>Type:</strong> <?php echo ucfirst(str_replace('_', ' ', $q['question_type'])); ?></p>
                
                <button type="submit" class="btn btn-primary">Update Question</button>
                <a href="<?php echo BASE_URL; ?>admin/questions.php?questionnaire_id=<?php echo $q['questionnaire_id']; ?>" class="btn btn-outline">Cancel</a>
            </form>
        </div>
    </div>
</div>

</body>
</html>
