<?php
require_once '../config.php';
require_once '../classes/Questionnaire.php';

if (!isAdmin()) {
    redirect(BASE_URL . 'auth/login.php');
}

$questionnaire_id = intval($_GET['questionnaire_id'] ?? 0);
$questionnaire = new Questionnaire($conn);

$quiz = $questionnaire->getById($questionnaire_id);
if (!$quiz) {
    redirect(BASE_URL . 'admin/questionnaires.php');
}

$message = '';
$error = '';

// Handle assignment
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $student_ids = isset($_POST['student_ids']) ? array_map('intval', $_POST['student_ids']) : [];
    
    if (count($student_ids) > 0) {
        $result = $questionnaire->assignToStudents($questionnaire_id, $student_ids);
        $message = 'Quiz assigned to ' . $result['assigned'] . ' student(s)';
    } else {
        $error = 'Please select at least one student';
    }
}

// Get all students
$query = "SELECT id, full_name, email FROM users WHERE role = 'student' ORDER BY full_name";
$students_result = $conn->query($query);

// Get already assigned students
$query = "SELECT student_id FROM student_questionnaire WHERE questionnaire_id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $questionnaire_id);
$stmt->execute();
$assigned_result = $stmt->get_result();
$assigned_students = array();
while ($row = $assigned_result->fetch_assoc()) {
    $assigned_students[] = $row['student_id'];
}

$page_title = 'Assign Students';
?>
<?php include '../includes/header.php'; ?>

<div class="container">
    <div class="card">
        <div class="card-header">
            <div class="card-title">Assign "<?php echo htmlspecialchars($quiz['title']); ?>" to Students</div>
        </div>
        <div class="card-content">
            <?php if ($message): ?>
                <div class="alert alert-success"><?php echo $message; ?></div>
            <?php endif; ?>
            
            <?php if ($error): ?>
                <div class="alert alert-danger"><?php echo $error; ?></div>
            <?php endif; ?>
            
            <form method="POST" action="">
                <div class="form-group">
                    <label>Select Students</label>
                    <div style="max-height: 400px; overflow-y: auto; border: 1px solid #bdc3c7; border-radius: 4px; padding: 1rem;">
                        <?php if ($students_result->num_rows > 0): ?>
                            <?php while ($student = $students_result->fetch_assoc()): ?>
                                <div style="padding: 0.5rem; margin-bottom: 0.5rem;">
                                    <label style="display: flex; align-items: center; margin: 0;">
                                        <input type="checkbox" name="student_ids[]" value="<?php echo $student['id']; ?>" 
                                            <?php echo in_array($student['id'], $assigned_students) ? 'checked' : ''; ?>>
                                        <span style="margin-left: 0.5rem;">
                                            <strong><?php echo htmlspecialchars($student['full_name']); ?></strong>
                                            <br>
                                            <small class="text-muted"><?php echo htmlspecialchars($student['email']); ?></small>
                                        </span>
                                    </label>
                                </div>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <p class="text-muted">No students found.</p>
                        <?php endif; ?>
                    </div>
                </div>
                
                <button type="submit" class="btn btn-primary">Assign Selected Students</button>
                <a href="<?php echo BASE_URL; ?>admin/questionnaires.php" class="btn btn-outline">Cancel</a>
            </form>
        </div>
    </div>
    
    <div class="card">
        <div class="card-header">
            <div class="card-title">Already Assigned (<?php echo count($assigned_students); ?>)</div>
        </div>
        <div class="card-content">
            <?php
            $assigned_result = $questionnaire->getAssignedStudents($questionnaire_id);
            
            if ($assigned_result->num_rows > 0):
            ?>
                <table class="table">
                    <thead>
                        <tr>
                            <th>Student Name</th>
                            <th>Email</th>
                            <th>Assigned Date</th>
                            <th>Attempts</th>
                            <th>Last Score</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($student = $assigned_result->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($student['full_name']); ?></td>
                                <td><?php echo htmlspecialchars($student['email']); ?></td>
                                <td><?php echo date('M d, Y', strtotime($student['assigned_at'])); ?></td>
                                <td><?php echo $student['attempts']; ?></td>
                                <td>
                                    <?php echo $student['last_score'] ? number_format($student['last_score'], 2) . '%' : '-'; ?>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p class="text-muted">No students assigned yet.</p>
            <?php endif; ?>
        </div>
    </div>
</div>

</body>
</html>
