# Quiz System - Quick Start Guide

## ⚡ 5-Minute Setup

### Step 1: Copy Files
1. Extract the downloaded files to your web root (e.g., `C:\xampp\htdocs\quiz_system` or `/var/www/html/quiz_system`)

### Step 2: Create Database
1. Open **phpMyAdmin** (usually `http://localhost/phpmyadmin`)
2. Create a new database named `quiz_system`
3. Select the database and go to **SQL** tab
4. Copy the contents of `database_schema.sql` and paste into the SQL editor
5. Click **Execute**

### Step 3: Configure Connection
1. Edit `config.php`
2. Update these lines with your database credentials:
```php
define('DB_HOST', 'localhost');
define('DB_USER', 'root');          // Your MySQL username
define('DB_PASS', '');              // Your MySQL password (if any)
define('DB_NAME', 'quiz_system');
```

### Step 4: Create Admin User
1. Open a terminal/command prompt
2. Run PHP and generate a password hash:
```php
php -r "echo password_hash('admin123', PASSWORD_BCRYPT);"
```
3. Copy the output hash
4. Go to phpMyAdmin, select `quiz_system` database
5. Click **SQL** tab and run:
```sql
INSERT INTO users (username, email, password, full_name, role) 
VALUES ('admin', 'admin@example.com', '[PASTE_HASH_HERE]', 'Administrator', 'admin');
```

### Step 5: Access Application
Open your browser and go to:
- **http://localhost/quiz_system/auth/login.php**

### Step 6: Login
- **Username:** admin
- **Password:** admin123

---

## 🎯 First Steps

### For Admin:
1. Go to **Questionnaires** → **Create New Questionnaire**
2. Fill in quiz details (title, duration, passing %)
3. Click **Create**
4. Click **Questions** and add questions
5. Set correct answers in **Options**
6. Click **Publish Questionnaire**
7. Click **Assign** to assign to students
8. View reports in **Reports** section

### For Students:
1. Register at **http://localhost/quiz_system/auth/register.php**
2. Go to **Dashboard**
3. Click **Start Quiz** on assigned questionnaire
4. Answer questions (auto-saves)
5. Click **Submit Quiz**
6. View results immediately

---

## 📁 File Structure

```
quiz_system/
├── config.php              ← Update database credentials HERE
├── database_schema.sql     ← Database tables definition
├── README.md              ← Full documentation
├── QUICK_START.md         ← This file
│
├── admin/                  ← Admin pages
│   ├── dashboard.php
│   ├── questionnaires.php
│   ├── questions.php
│   ├── reports.php
│   └── ...
│
├── student/               ← Student pages
│   ├── dashboard.php
│   ├── take-quiz.php
│   ├── quiz-result.php
│   └── progress.php
│
├── auth/                  ← Authentication
│   ├── login.php
│   ├── register.php
│   └── logout.php
│
├── classes/               ← PHP classes
│   ├── Auth.php
│   ├── Questionnaire.php
│   ├── Question.php
│   └── ...
│
├── includes/              ← Reusable components
│   └── header.php
│
└── public/css/            ← Styling
    └── style.css
```

---

## 🔧 Common Issues & Solutions

### "Connection failed" Error
**Problem:** Can't connect to database
**Solution:** 
- Check MySQL is running
- Verify username/password in `config.php`
- Make sure database name is correct

### "File not found" Error
**Problem:** Pages show 404
**Solution:**
- Check `BASE_URL` in `config.php` matches your installation path
- Ensure all files are in correct directories

### Blank Pages
**Problem:** Page loads but shows nothing
**Solution:**
- Check PHP error logs
- Ensure PHP 7.4+ is installed
- Verify all class files exist

### Timer Not Working
**Problem:** Quiz timer doesn't countdown
**Solution:**
- Check browser console for JavaScript errors
- Ensure JavaScript is enabled

---

## 🔐 Security Notes

⚠️ **Important for Production:**
1. Change admin password immediately
2. Update `DB_PASS` in `config.php`
3. Set file permissions: `chmod 755` directories, `chmod 644` files
4. Consider SSL/HTTPS
5. Regular backups of database

---

## 📊 Features Included

✅ User registration & login  
✅ Admin questionnaire management  
✅ Multiple question types  
✅ Auto-save during quiz  
✅ Timer with auto-submit  
✅ Automatic scoring  
✅ Student progress tracking  
✅ Detailed analytics reports  
✅ Responsive design  
✅ Role-based access control  

---

## 🚀 Next Steps

1. **Create Quizzes** - Start by creating sample questionnaires
2. **Add Questions** - Build a question bank
3. **Invite Students** - Register student accounts
4. **Assign Quizzes** - Distribute to students
5. **Monitor Progress** - Track performance in reports

---

## 💡 Tips

- **Question Types:** Multiple choice, True/False, Short Answer
- **Passing %:** Set appropriate passing percentage for each quiz
- **Timing:** Quiz automatically submits when time runs out
- **Reports:** All data available in Reports section
- **Retakes:** Students can retake quizzes (best score tracked)

---

## 📞 Support

For full documentation, see **README.md**

Common questions answered in README:
- Database schema explanation
- All class and file descriptions
- Performance optimization
- Backup & restore procedures
- Advanced configuration

---

**You're all set! Start by logging in as admin and creating your first quiz.** 🎓
